package com.xforceplus.ultraman.app.generalvoucher.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * validate_date_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-26
 */
public enum ValidateDateType {

    ABS("abs", "绝对有效期"),
    REL("rel", "相对有效期");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ValidateDateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValidateDateType fromCode(String code){
        switch(code) {
            case "abs":
                return ABS;
            case "rel":
                return REL;
            default:
                return null;
        }
    }
}
