package com.xforceplus.ultraman.app.generalvoucher.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * industry
 * </p>
 *
 * @author ultraman
 * @since 2025-09-26
 */
public enum Industry {

    TEA("tea", "茶饮连锁"),
    BRAND("brand", "品牌商");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Industry(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Industry fromCode(String code){
        switch(code) {
            case "tea":
                return TEA;
            case "brand":
                return BRAND;
            default:
                return null;
        }
    }
}
