package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * message_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-19
 */
public enum MessageType {

    _0("0", "站内信"),
    _1("1", "邮件"),
    _2("2", "短信"),
    _3("3", "钉钉消息"),
    _4("4", "企业微信");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MessageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageType fromCode(String code) {
        return Stream.of(MessageType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
