package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * platform_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-19
 */
public enum PlatformType {

    WH("wh", "福利平台"),
    PM("pm", "积分商城"),
    EP("ep", "企业");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PlatformType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlatformType fromCode(String code) {
        return Stream.of(PlatformType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
