package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * validate_date_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum ValidateDateType {

    ABS("abs", "绝对有效期"),
    REL("rel", "相对有效期");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ValidateDateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValidateDateType fromCode(String code) {
        return Stream.of(ValidateDateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
