package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * redeem_event_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-24
 */
public enum RedeemEventType {

    REQ("req", "REDEEM_REQUESTED核销请求"),
    SUC("suc", "REDEEM_SUCCEEDED核销成功"),
    FAIL("fail", "REDEEM_FAILED核销失败"),
    RBK("rbk", "REDEEM_ROLLBACK核销回退"),
    LCK("lck", "REDEEM_LOCKED券码冻结"),
    ULK("ulk", "REDEEM_UNLOCKED券码解冻");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedeemEventType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedeemEventType fromCode(String code) {
        return Stream.of(RedeemEventType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
