package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_gen_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-25
 */
public enum VoucherGenStatus {

    DRAFT("draft", "草稿"),
    AVAIL("avail", "生效"),
    FROZEN("frozen", "冻结"),
    ABD("abd", "作废"),
    END("end", "结束");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VoucherGenStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherGenStatus fromCode(String code) {
        return Stream.of(VoucherGenStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
