package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-25
 */
public enum VoucherStatus {

    _0("0", "待激活"),
    _1("1", "已激活"),
    _2("2", "已冻结"),
    _3("3", "已作废"),
    _6("6", "已核销"),
    _7("7", "已部分核销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VoucherStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherStatus fromCode(String code) {
        return Stream.of(VoucherStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
