package com.xforceplus.ultraman.app.generalvoucher.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * industry
 * </p>
 *
 * @author ultraman
 * @since 2025-09-26
 */
public enum Industry {

    TEA("tea", "茶饮连锁"),
    BRAND("brand", "品牌商");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Industry(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Industry fromCode(String code) {
        return Stream.of(Industry.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
