package com.xforceplus.ultraman.app.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.BrandConfig;
import com.xforceplus.ultraman.app.generalvoucher.service.IBrandConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-23
 */
@RestController
public class BrandConfigController {

  @Autowired
  private IBrandConfigService brandConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param brandConfig ${table.comment}
   * @return
   */
  @GetMapping("/brandconfigs" )
  public XfR getBrandConfigs(XfPage page, BrandConfig brandConfig) {
    return XfR.ok(brandConfigServiceImpl.page(page, Wrappers.query(brandConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/brandconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(brandConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param brandConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/brandconfigs")
  public XfR save(@RequestBody BrandConfig brandConfig) {
     return XfR.ok(brandConfigServiceImpl.save(brandConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param brandConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/brandconfigs/{id}")
  public XfR putUpdate(@RequestBody BrandConfig brandConfig,@PathVariable Long id) {
      brandConfig.setId(id);
      return XfR.ok(brandConfigServiceImpl.updateById(brandConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param brandConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/brandconfigs/{id}")
  public XfR patchUpdate(@RequestBody BrandConfig brandConfig,@PathVariable Long id) {
      BrandConfig upbrandConfig = brandConfigServiceImpl.getById(id);
      if(upbrandConfig != null){
        upbrandConfig = ObjectCopyUtils.copyProperties(brandConfig,upbrandConfig,true);
      }
      return XfR.ok(brandConfigServiceImpl.updateById(upbrandConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/brandconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(brandConfigServiceImpl.removeById(id));
  }

  @PostMapping("/brandconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "brand_config");
     params.put("request", condition);

     return XfR.ok(brandConfigServiceImpl.querys(params));
  }

}
