package com.xforceplus.ultraman.app.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.DistributionTask;
import com.xforceplus.ultraman.app.generalvoucher.service.IDistributionTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-24
 */
@RestController
public class DistributionTaskController {

  @Autowired
  private IDistributionTaskService distributionTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param distributionTask ${table.comment}
   * @return
   */
  @GetMapping("/distributiontasks" )
  public XfR getDistributionTasks(XfPage page, DistributionTask distributionTask) {
    return XfR.ok(distributionTaskServiceImpl.page(page, Wrappers.query(distributionTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/distributiontasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(distributionTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param distributionTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/distributiontasks")
  public XfR save(@RequestBody DistributionTask distributionTask) {
     return XfR.ok(distributionTaskServiceImpl.save(distributionTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param distributionTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/distributiontasks/{id}")
  public XfR putUpdate(@RequestBody DistributionTask distributionTask,@PathVariable Long id) {
      distributionTask.setId(id);
      return XfR.ok(distributionTaskServiceImpl.updateById(distributionTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param distributionTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/distributiontasks/{id}")
  public XfR patchUpdate(@RequestBody DistributionTask distributionTask,@PathVariable Long id) {
      DistributionTask updistributionTask = distributionTaskServiceImpl.getById(id);
      if(updistributionTask != null){
        updistributionTask = ObjectCopyUtils.copyProperties(distributionTask,updistributionTask,true);
      }
      return XfR.ok(distributionTaskServiceImpl.updateById(updistributionTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/distributiontasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(distributionTaskServiceImpl.removeById(id));
  }

  @PostMapping("/distributiontasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "distribution_task");
     params.put("request", condition);

     return XfR.ok(distributionTaskServiceImpl.querys(params));
  }

}
