package com.xforceplus.ultraman.app.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.Brand;
import com.xforceplus.ultraman.app.generalvoucher.service.IBrandService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-25
 */
@RestController
public class BrandController {

  @Autowired
  private IBrandService brandServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param brand ${table.comment}
   * @return
   */
  @GetMapping("/brands" )
  public XfR getBrands(XfPage page, Brand brand) {
    return XfR.ok(brandServiceImpl.page(page, Wrappers.query(brand)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/brands/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(brandServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param brand ${table.comment}
   * @return XfR
   */
  @PostMapping("/brands")
  public XfR save(@RequestBody Brand brand) {
     return XfR.ok(brandServiceImpl.save(brand));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param brand ${table.comment}
   * @return XfR
   */
  @PutMapping("/brands/{id}")
  public XfR putUpdate(@RequestBody Brand brand,@PathVariable Long id) {
      brand.setId(id);
      return XfR.ok(brandServiceImpl.updateById(brand));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param brand ${table.comment}
   * @return XfR
   */
  @PatchMapping("/brands/{id}")
  public XfR patchUpdate(@RequestBody Brand brand,@PathVariable Long id) {
      Brand upbrand = brandServiceImpl.getById(id);
      if(upbrand != null){
        upbrand = ObjectCopyUtils.copyProperties(brand,upbrand,true);
      }
      return XfR.ok(brandServiceImpl.updateById(upbrand));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/brands/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(brandServiceImpl.removeById(id));
  }

  @PostMapping("/brands/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "brand");
     params.put("request", condition);

     return XfR.ok(brandServiceImpl.querys(params));
  }

}
