package com.xforceplus.ultraman.app.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.TransactionLog;
import com.xforceplus.ultraman.app.generalvoucher.service.ITransactionLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-25
 */
@RestController
public class TransactionLogController {

  @Autowired
  private ITransactionLogService transactionLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param transactionLog ${table.comment}
   * @return
   */
  @GetMapping("/transactionlogs" )
  public XfR getTransactionLogs(XfPage page, TransactionLog transactionLog) {
    return XfR.ok(transactionLogServiceImpl.page(page, Wrappers.query(transactionLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/transactionlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(transactionLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param transactionLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/transactionlogs")
  public XfR save(@RequestBody TransactionLog transactionLog) {
     return XfR.ok(transactionLogServiceImpl.save(transactionLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param transactionLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/transactionlogs/{id}")
  public XfR putUpdate(@RequestBody TransactionLog transactionLog,@PathVariable Long id) {
      transactionLog.setId(id);
      return XfR.ok(transactionLogServiceImpl.updateById(transactionLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param transactionLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/transactionlogs/{id}")
  public XfR patchUpdate(@RequestBody TransactionLog transactionLog,@PathVariable Long id) {
      TransactionLog uptransactionLog = transactionLogServiceImpl.getById(id);
      if(uptransactionLog != null){
        uptransactionLog = ObjectCopyUtils.copyProperties(transactionLog,uptransactionLog,true);
      }
      return XfR.ok(transactionLogServiceImpl.updateById(uptransactionLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/transactionlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(transactionLogServiceImpl.removeById(id));
  }

  @PostMapping("/transactionlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "transaction_log");
     params.put("request", condition);

     return XfR.ok(transactionLogServiceImpl.querys(params));
  }

}
