package com.xforceplus.ultraman.app.generalvoucher.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.generalvoucher.entity.DistributionPlatform;
import com.xforceplus.ultraman.app.generalvoucher.service.IDistributionPlatformService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-09-26
 */
@RestController
public class DistributionPlatformController {

  @Autowired
  private IDistributionPlatformService distributionPlatformServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param distributionPlatform ${table.comment}
   * @return
   */
  @GetMapping("/distributionplatforms" )
  public XfR getDistributionPlatforms(XfPage page, DistributionPlatform distributionPlatform) {
    return XfR.ok(distributionPlatformServiceImpl.page(page, Wrappers.query(distributionPlatform)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/distributionplatforms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(distributionPlatformServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param distributionPlatform ${table.comment}
   * @return XfR
   */
  @PostMapping("/distributionplatforms")
  public XfR save(@RequestBody DistributionPlatform distributionPlatform) {
     return XfR.ok(distributionPlatformServiceImpl.save(distributionPlatform));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param distributionPlatform ${table.comment}
   * @return XfR
   */
  @PutMapping("/distributionplatforms/{id}")
  public XfR putUpdate(@RequestBody DistributionPlatform distributionPlatform,@PathVariable Long id) {
      distributionPlatform.setId(id);
      return XfR.ok(distributionPlatformServiceImpl.updateById(distributionPlatform));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param distributionPlatform ${table.comment}
   * @return XfR
   */
  @PatchMapping("/distributionplatforms/{id}")
  public XfR patchUpdate(@RequestBody DistributionPlatform distributionPlatform,@PathVariable Long id) {
      DistributionPlatform updistributionPlatform = distributionPlatformServiceImpl.getById(id);
      if(updistributionPlatform != null){
        updistributionPlatform = ObjectCopyUtils.copyProperties(distributionPlatform,updistributionPlatform,true);
      }
      return XfR.ok(distributionPlatformServiceImpl.updateById(updistributionPlatform));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/distributionplatforms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(distributionPlatformServiceImpl.removeById(id));
  }

  @PostMapping("/distributionplatforms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "distribution_platform");
     params.put("request", condition);

     return XfR.ok(distributionPlatformServiceImpl.querys(params));
  }

}
