package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 记账工单feign客户端
 *
 * @author ultraman
 * @date 2021-12-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.AccountBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface AccountBillFeignApi {

  /**
   * 通过id查询记账工单
   * @param  id
   * @return R
   */
  @GetMapping("/accountBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增记账工单
   * @param accountBill 记账工单
   * @return R
   */
  @PostMapping("/accountBill/add")
  public R save(@RequestBody AccountBill accountBill);

  /**
   * 修改记账工单
   * @param accountBill 记账工单
   * @return R
   */
  @PostMapping("/accountBill/update")
  public R updateById(@RequestBody AccountBill accountBill);

  /**
   * 通过id删除记账工单
   * @param  id
   * @return R
   */
  @DeleteMapping("/accountBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}