package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的采购类单据feign客户端
 *
 * @author ultraman
 * @date 2021-12-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ComparePurchaseBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface ComparePurchaseBillFeignApi {

  /**
   * 通过id查询数据比对用途的采购类单据
   * @param  id
   * @return R
   */
  @GetMapping("/comparePurchaseBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的采购类单据
   * @param comparePurchaseBill 数据比对用途的采购类单据
   * @return R
   */
  @PostMapping("/comparePurchaseBill/add")
  public R save(@RequestBody ComparePurchaseBill comparePurchaseBill);

  /**
   * 修改数据比对用途的采购类单据
   * @param comparePurchaseBill 数据比对用途的采购类单据
   * @return R
   */
  @PostMapping("/comparePurchaseBill/update")
  public R updateById(@RequestBody ComparePurchaseBill comparePurchaseBill);

  /**
   * 通过id删除数据比对用途的采购类单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/comparePurchaseBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}