package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的其他发票feign客户端
 *
 * @author ultraman
 * @date 2021-12-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketOther;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketOtherFeignApi {

  /**
   * 通过id查询数据比对用途的其他发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketOther/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的其他发票
   * @param compareTicketOther 数据比对用途的其他发票
   * @return R
   */
  @PostMapping("/compareTicketOther/add")
  public R save(@RequestBody CompareTicketOther compareTicketOther);

  /**
   * 修改数据比对用途的其他发票
   * @param compareTicketOther 数据比对用途的其他发票
   * @return R
   */
  @PostMapping("/compareTicketOther/update")
  public R updateById(@RequestBody CompareTicketOther compareTicketOther);

  /**
   * 通过id删除数据比对用途的其他发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketOther/del/{id}" )
  public R removeById(@PathVariable Long id);

}