package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途 - 记账工单feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareAccountBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareAccountBillFeignApi {

  /**
   * 通过id查询数据比对用途 - 记账工单
   * @param  id
   * @return R
   */
  @GetMapping("/compareAccountBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途 - 记账工单
   * @param compareAccountBill 数据比对用途 - 记账工单
   * @return R
   */
  @PostMapping("/compareAccountBill/add")
  public R save(@RequestBody CompareAccountBill compareAccountBill);

  /**
   * 修改数据比对用途 - 记账工单
   * @param compareAccountBill 数据比对用途 - 记账工单
   * @return R
   */
  @PostMapping("/compareAccountBill/update")
  public R updateById(@RequestBody CompareAccountBill compareAccountBill);

  /**
   * 通过id删除数据比对用途 - 记账工单
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareAccountBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}