package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的附件feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketAttachment;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketAttachmentFeignApi {

  /**
   * 通过id查询数据比对用途的附件
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketAttachment/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的附件
   * @param compareTicketAttachment 数据比对用途的附件
   * @return R
   */
  @PostMapping("/compareTicketAttachment/add")
  public R save(@RequestBody CompareTicketAttachment compareTicketAttachment);

  /**
   * 修改数据比对用途的附件
   * @param compareTicketAttachment 数据比对用途的附件
   * @return R
   */
  @PostMapping("/compareTicketAttachment/update")
  public R updateById(@RequestBody CompareTicketAttachment compareTicketAttachment);

  /**
   * 通过id删除数据比对用途的附件
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketAttachment/del/{id}" )
  public R removeById(@PathVariable Long id);

}