package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的过路费发票feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketToll;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketTollFeignApi {

  /**
   * 通过id查询数据比对用途的过路费发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketToll/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的过路费发票
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return R
   */
  @PostMapping("/compareTicketToll/add")
  public R save(@RequestBody CompareTicketToll compareTicketToll);

  /**
   * 修改数据比对用途的过路费发票
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return R
   */
  @PostMapping("/compareTicketToll/update")
  public R updateById(@RequestBody CompareTicketToll compareTicketToll);

  /**
   * 通过id删除数据比对用途的过路费发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketToll/del/{id}" )
  public R removeById(@PathVariable Long id);

}