package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 任务队列feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TaskQueue;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TaskQueueFeignApi {

  /**
   * 通过id查询任务队列
   * @param  id
   * @return R
   */
  @GetMapping("/taskQueue/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增任务队列
   * @param taskQueue 任务队列
   * @return R
   */
  @PostMapping("/taskQueue/add")
  public R save(@RequestBody TaskQueue taskQueue);

  /**
   * 修改任务队列
   * @param taskQueue 任务队列
   * @return R
   */
  @PostMapping("/taskQueue/update")
  public R updateById(@RequestBody TaskQueue taskQueue);

  /**
   * 通过id删除任务队列
   * @param  id
   * @return R
   */
  @DeleteMapping("/taskQueue/del/{id}" )
  public R removeById(@PathVariable Long id);

}