package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 审批单证feign客户端
 *
 * @author ultraman
 * @date 2022-04-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketAudit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TicketAuditFeignApi {

  /**
   * 通过id查询审批单证
   * @param  id
   * @return R
   */
  @GetMapping("/ticketAudit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增审批单证
   * @param ticketAudit 审批单证
   * @return R
   */
  @PostMapping("/ticketAudit/add")
  public R save(@RequestBody TicketAudit ticketAudit);

  /**
   * 修改审批单证
   * @param ticketAudit 审批单证
   * @return R
   */
  @PostMapping("/ticketAudit/update")
  public R updateById(@RequestBody TicketAudit ticketAudit);

  /**
   * 通过id删除审批单证
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketAudit/del/{id}" )
  public R removeById(@PathVariable Long id);

}