package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 比对海关缴款书明细feign客户端
 *
 * @author ultraman
 * @date 2023-03-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketCustomsPaymentDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketCustomsPaymentDetailFeignApi {

  /**
   * 通过id查询比对海关缴款书明细
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketCustomsPaymentDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对海关缴款书明细
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return R
   */
  @PostMapping("/compareTicketCustomsPaymentDetail/add")
  public R save(@RequestBody CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail);

  /**
   * 修改比对海关缴款书明细
   * @param compareTicketCustomsPaymentDetail 比对海关缴款书明细
   * @return R
   */
  @PostMapping("/compareTicketCustomsPaymentDetail/update")
  public R updateById(@RequestBody CompareTicketCustomsPaymentDetail compareTicketCustomsPaymentDetail);

  /**
   * 通过id删除比对海关缴款书明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketCustomsPaymentDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}