package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 比对医疗票据feign客户端
 *
 * @author ultraman
 * @date 2023-03-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketMedical;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketMedicalFeignApi {

  /**
   * 通过id查询比对医疗票据
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketMedical/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对医疗票据
   * @param compareTicketMedical 比对医疗票据
   * @return R
   */
  @PostMapping("/compareTicketMedical/add")
  public R save(@RequestBody CompareTicketMedical compareTicketMedical);

  /**
   * 修改比对医疗票据
   * @param compareTicketMedical 比对医疗票据
   * @return R
   */
  @PostMapping("/compareTicketMedical/update")
  public R updateById(@RequestBody CompareTicketMedical compareTicketMedical);

  /**
   * 通过id删除比对医疗票据
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketMedical/del/{id}" )
  public R removeById(@PathVariable Long id);

}