package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 影像文件feign客户端
 *
 * @author ultraman
 * @date 2023-03-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ImageFile;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface ImageFileFeignApi {

  /**
   * 通过id查询影像文件
   * @param  id
   * @return R
   */
  @GetMapping("/imageFile/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增影像文件
   * @param imageFile 影像文件
   * @return R
   */
  @PostMapping("/imageFile/add")
  public R save(@RequestBody ImageFile imageFile);

  /**
   * 修改影像文件
   * @param imageFile 影像文件
   * @return R
   */
  @PostMapping("/imageFile/update")
  public R updateById(@RequestBody ImageFile imageFile);

  /**
   * 通过id删除影像文件
   * @param  id
   * @return R
   */
  @DeleteMapping("/imageFile/del/{id}" )
  public R removeById(@PathVariable Long id);

}