package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 任务历史记录feign客户端
 *
 * @author ultraman
 * @date 2023-03-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TaskHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TaskHistoryFeignApi {

  /**
   * 通过id查询任务历史记录
   * @param  id
   * @return R
   */
  @GetMapping("/taskHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增任务历史记录
   * @param taskHistory 任务历史记录
   * @return R
   */
  @PostMapping("/taskHistory/add")
  public R save(@RequestBody TaskHistory taskHistory);

  /**
   * 修改任务历史记录
   * @param taskHistory 任务历史记录
   * @return R
   */
  @PostMapping("/taskHistory/update")
  public R updateById(@RequestBody TaskHistory taskHistory);

  /**
   * 通过id删除任务历史记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/taskHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}