package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 应付款feign客户端
 *
 * @author ultraman
 * @date 2023-03-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketPayment;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TicketPaymentFeignApi {

  /**
   * 通过id查询应付款
   * @param  id
   * @return R
   */
  @GetMapping("/ticketPayment/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应付款
   * @param ticketPayment 应付款
   * @return R
   */
  @PostMapping("/ticketPayment/add")
  public R save(@RequestBody TicketPayment ticketPayment);

  /**
   * 修改应付款
   * @param ticketPayment 应付款
   * @return R
   */
  @PostMapping("/ticketPayment/update")
  public R updateById(@RequestBody TicketPayment ticketPayment);

  /**
   * 通过id删除应付款
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketPayment/del/{id}" )
  public R removeById(@PathVariable Long id);

}