package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 比对财政票据明细feign客户端
 *
 * @author ultraman
 * @date 2023-08-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketFinanceDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketFinanceDetailFeignApi {

  /**
   * 通过id查询比对财政票据明细
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketFinanceDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对财政票据明细
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return R
   */
  @PostMapping("/compareTicketFinanceDetail/add")
  public R save(@RequestBody CompareTicketFinanceDetail compareTicketFinanceDetail);

  /**
   * 修改比对财政票据明细
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return R
   */
  @PostMapping("/compareTicketFinanceDetail/update")
  public R updateById(@RequestBody CompareTicketFinanceDetail compareTicketFinanceDetail);

  /**
   * 通过id删除比对财政票据明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketFinanceDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}