package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的机动车销售统一发票feign客户端
 *
 * @author ultraman
 * @date 2023-08-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketVehicle;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketVehicleFeignApi {

  /**
   * 通过id查询数据比对用途的机动车销售统一发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketVehicle/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的机动车销售统一发票
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return R
   */
  @PostMapping("/compareTicketVehicle/add")
  public R save(@RequestBody CompareTicketVehicle compareTicketVehicle);

  /**
   * 修改数据比对用途的机动车销售统一发票
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return R
   */
  @PostMapping("/compareTicketVehicle/update")
  public R updateById(@RequestBody CompareTicketVehicle compareTicketVehicle);

  /**
   * 通过id删除数据比对用途的机动车销售统一发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketVehicle/del/{id}" )
  public R removeById(@PathVariable Long id);

}