package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的基础单据feign客户端
 *
 * @author ultraman
 * @date 2023-11-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareBaseBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareBaseBillFeignApi {

  /**
   * 通过id查询数据比对用途的基础单据
   * @param  id
   * @return R
   */
  @GetMapping("/compareBaseBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的基础单据
   * @param compareBaseBill 数据比对用途的基础单据
   * @return R
   */
  @PostMapping("/compareBaseBill/add")
  public R save(@RequestBody CompareBaseBill compareBaseBill);

  /**
   * 修改数据比对用途的基础单据
   * @param compareBaseBill 数据比对用途的基础单据
   * @return R
   */
  @PostMapping("/compareBaseBill/update")
  public R updateById(@RequestBody CompareBaseBill compareBaseBill);

  /**
   * 通过id删除数据比对用途的基础单据
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareBaseBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}