package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 数据比对用途的对账单feign客户端
 *
 * @author ultraman
 * @date 2023-11-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareStatementBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareStatementBillFeignApi {

  /**
   * 通过id查询数据比对用途的对账单
   * @param  id
   * @return R
   */
  @GetMapping("/compareStatementBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的对账单
   * @param compareStatementBill 数据比对用途的对账单
   * @return R
   */
  @PostMapping("/compareStatementBill/add")
  public R save(@RequestBody CompareStatementBill compareStatementBill);

  /**
   * 修改数据比对用途的对账单
   * @param compareStatementBill 数据比对用途的对账单
   * @return R
   */
  @PostMapping("/compareStatementBill/update")
  public R updateById(@RequestBody CompareStatementBill compareStatementBill);

  /**
   * 通过id删除数据比对用途的对账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareStatementBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}