package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 比对医疗票据明细feign客户端
 *
 * @author ultraman
 * @date 2023-11-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketMedicalDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface CompareTicketMedicalDetailFeignApi {

  /**
   * 通过id查询比对医疗票据明细
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketMedicalDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对医疗票据明细
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return R
   */
  @PostMapping("/compareTicketMedicalDetail/add")
  public R save(@RequestBody CompareTicketMedicalDetail compareTicketMedicalDetail);

  /**
   * 修改比对医疗票据明细
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return R
   */
  @PostMapping("/compareTicketMedicalDetail/update")
  public R updateById(@RequestBody CompareTicketMedicalDetail compareTicketMedicalDetail);

  /**
   * 通过id删除比对医疗票据明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketMedicalDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}