package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 测试feign客户端
 *
 * @author ultraman
 * @date 2023-11-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.Dummy;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface DummyFeignApi {

  /**
   * 通过id查询测试
   * @param  id
   * @return R
   */
  @GetMapping("/dummy/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增测试
   * @param dummy 测试
   * @return R
   */
  @PostMapping("/dummy/add")
  public R save(@RequestBody Dummy dummy);

  /**
   * 修改测试
   * @param dummy 测试
   * @return R
   */
  @PostMapping("/dummy/update")
  public R updateById(@RequestBody Dummy dummy);

  /**
   * 通过id删除测试
   * @param  id
   * @return R
   */
  @DeleteMapping("/dummy/del/{id}" )
  public R removeById(@PathVariable Long id);

}