package com.xforceplus.ultraman.app.imagesaas.controller;


/**
 * 机动车销售统一发票feign客户端
 *
 * @author ultraman
 * @date 2023-11-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketVehicle;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-saas")
public interface TicketVehicleFeignApi {

  /**
   * 通过id查询机动车销售统一发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketVehicle/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增机动车销售统一发票
   * @param ticketVehicle 机动车销售统一发票
   * @return R
   */
  @PostMapping("/ticketVehicle/add")
  public R save(@RequestBody TicketVehicle ticketVehicle);

  /**
   * 修改机动车销售统一发票
   * @param ticketVehicle 机动车销售统一发票
   * @return R
   */
  @PostMapping("/ticketVehicle/update")
  public R updateById(@RequestBody TicketVehicle ticketVehicle);

  /**
   * 通过id删除机动车销售统一发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketVehicle/del/{id}" )
  public R removeById(@PathVariable Long id);

}