package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据类型
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
public enum BillTypeCode {

    A("A", "扫描发票"),
    B("B", "扫描无订单发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTypeCode fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            default:
                return null;
        }
    }
}
