package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测种类
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
public enum CheckCategory {

    BILL("BILL", "单据"),
    TICKET("TICKET", "单证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckCategory fromCode(String code){
        switch(code) {
            case "BILL":
                return BILL;
            case "TICKET":
                return TICKET;
            default:
                return null;
        }
    }
}
