package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 外部系统来源
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
public enum SystemOrigExternal {

    _0("0", "-");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SystemOrigExternal(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemOrigExternal fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
