package com.xforceplus.ultraman.app.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 业务日志
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BusinessLog implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务对象id
   */
  private Long businessId;

  /**
   * 业务对象Code
   */
  private String businessCode;

  /**
   * 业务日志类型
   */
  private String businessType;

  /**
   * 所属租户
   */
  private Long tenant;

  /**
   * 原状态
   */
  private String origStatus;

  /**
   * 新状态
   */
  private String newStatus;

  /**
   * 操作名称
   */
  private String operatorName;

  /**
   * 操作备注
   */
  private String remark;

  /**
   * 内容
   */
  private String content;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 变更描述
   */
  private String changeDesc;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_id", businessId);
      map.put("business_code", businessCode);
      map.put("business_type", businessType);
      map.put("tenant", tenant);
      map.put("orig_status", origStatus);
      map.put("new_status", newStatus);
      map.put("operator_name", operatorName);
      map.put("remark", remark);
      map.put("content", content);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("change_desc", changeDesc);
      return map;
  }

  public static BusinessLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BusinessLog entity = new BusinessLog();
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("business_code")) {
      Object obj = map.get("business_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orig_status")) {
      Object obj = map.get("orig_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_status")) {
      Object obj = map.get("new_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operator_name")) {
      Object obj = map.get("operator_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperatorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("content")) {
      Object obj = map.get("content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("change_desc")) {
      Object obj = map.get("change_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeDesc((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
