package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像来源
 * </p>
 *
 * @author ultraman
 * @since 2022-05-26
 */
public enum ImageSource {

    _1("1", "扫描"),
    _2("2", "上传"),
    _3("3", "接口"),
    _99("99", "其他"),
    _4("4", "票税助手"),
    _5("5", "移动端上传"),
    _6("6", "滴滴卡包"),
    _7("7", "支付宝卡包"),
    _8("8", "微信卡包"),
    _9("9", "微信"),
    ANT("Ant", "协同"),
    _10("10", "复制链接");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImageSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageSource fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "99":
                return _99;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "Ant":
                return ANT;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
