package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据购销类型
 * </p>
 *
 * @author ultraman
 * @since 2022-05-26
 */
public enum SettlementType {

    AP("AP", "进项单据"),
    AR("AR", "销项单据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SettlementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementType fromCode(String code){
        switch(code) {
            case "AP":
                return AP;
            case "AR":
                return AR;
            default:
                return null;
        }
    }
}
