package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证类型
 * </p>
 *
 * @author ultraman
 * @since 2022-05-26
 */
public enum TicketType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    D("d", "多票"),
    F("f", "附件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "d":
                return D;
            case "f":
                return F;
            default:
                return null;
        }
    }
}
