package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测种类
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum CheckCategory {

    BILL("BILL", "单据"),
    TICKET("TICKET", "单证"),
    COOP("COOP", "协同"),
    COMPARE_BILL("COMPARE_BILL", "收单单据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckCategory fromCode(String code){
        switch(code) {
            case "BILL":
                return BILL;
            case "TICKET":
                return TICKET;
            case "COOP":
                return COOP;
            case "COMPARE_BILL":
                return COMPARE_BILL;
            default:
                return null;
        }
    }
}
