package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum ImageType {

    _1("1", "单据"),
    _2("2", "单证"),
    _3("3", "多票"),
    _99("99", "附件"),
    _4("4", "其他"),
    _5("5", "文件"),
    _9("9", "销货清单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "99":
                return _99;
            case "4":
                return _4;
            case "5":
                return _5;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
