package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 运维类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum OperationType {

    PUSH_BILL("pushBill", "推送单据"),
    PUSH_TICKET("pushTicket", "推送单证"),
    RE_CHECK_BILL("reCheckBill", "重算单据"),
    RE_CHECK_TICKET("reCheckTicket", "重算单证"),
    RE_VERIFY("reVerify", "重新验真"),
    PDF_VERIFY_PASS("pdfVerifyPass", "PDF验签通过"),
    DELETE_TICKET("deleteTicket", "删除单证"),
    DELETE_BILL("deleteBill", "删除单据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationType fromCode(String code){
        switch(code) {
            case "pushBill":
                return PUSH_BILL;
            case "pushTicket":
                return PUSH_TICKET;
            case "reCheckBill":
                return RE_CHECK_BILL;
            case "reCheckTicket":
                return RE_CHECK_TICKET;
            case "reVerify":
                return RE_VERIFY;
            case "pdfVerifyPass":
                return PDF_VERIFY_PASS;
            case "deleteTicket":
                return DELETE_TICKET;
            case "deleteBill":
                return DELETE_BILL;
            default:
                return null;
        }
    }
}
