package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证检测项
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum TicketCheckOptions {

    BASE_CHECK("base_check", "基础校验不通过"),
    TITLE_CHECK("title_check", "单据单证抬头不匹配"),
    BLACKLIST_CHECK("blacklist_check", "黑名单校验不通过"),
    SENSITIVE_CHECK("sensitive_check", "敏感词校验不通过"),
    COORDINATION_CHECK("coordination_check", "协同销方税号校验不通过"),
    ELECTRONIC_CHECK("electronic_check", "电票源文件格式错误"),
    ERROR_CODE_NO_CHECK("error_code_no_check", "发票串号"),
    INVOICE_STATUS_CHECK("invoice_status_check", "发票已作废或已红冲"),
    IS_REPLACE_CHECK("is_replace_check", "税局代开发票"),
    LEGAL_PERSON_CHECK("legal_person_check", "法人主数据不存在"),
    PERSON_CHECK("person_check", "个人抬头发票错误"),
    REPEAT_CHECK("repeat_check", "发票重复"),
    SALES_LIST_CHECK("sales_list_check", "销货清单挂接错误"),
    CONSECUTIVE_CHECK("consecutive_check", "发票连号"),
    SHEET_CHECK("sheet_check", "缺失联次"),
    STAMPER_CHECK("stamper_check", "发票专用章不存在"),
    USER_AUTH_CHECK("user_auth_check", "用户没有扫描权限"),
    VERIFY_RESULT_CHECK("verify_result_check", "验真状态不正常"),
    SIGN_RESULT_CHECK("sign_result_check", "验签状态不正常"),
    PURCHASE_REPEAT_CHECK("purchase_repeat_check", "进项重复"),
    SHEET_DEDUCT_CHECK("sheet_deduct_check", "抵扣联发票"),
    TICKET_REMARK_CHECK("ticket_remark_check", "发票备注含关键词"),
    REC_FAILED_CHECK("rec_failed_check", "识别失败"),
    USED_AMOUNT_CHECK("used_amount_check", "提报金额异常"),
    CUSTOMS_PAYMENT_CHECK("customs_payment_check", "海关缴款书异常"),
    INVOICE_PURCHASER_TAX_NO_CHECK("invoice_purchaser_tax_no_check", "非增票权限校验不通过"),
    ALL_ELECTRIC_AUTH_CHECK("all_electric_auth_check", "全电发票权限未开通"),
    IS_COVER_TICKET_CHECK("is_cover_ticket_check", "已覆盖重复发票"),
    BALANCE_AMOUNT_CHECK("balance_amount_check", "发票余额大于0"),
    PURCHASE_COOPERATE_CHECK("purchase_cooperate_check", "供应商未回填发票"),
    SPECIAL_INVOICE_CHECK("special_invoice_check", "特殊行业发票明细校验不通过"),
    TICKET_BANK_CHECK("ticket_bank_check", "银行地址电话为空");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketCheckOptions(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketCheckOptions fromCode(String code){
        switch(code) {
            case "base_check":
                return BASE_CHECK;
            case "title_check":
                return TITLE_CHECK;
            case "blacklist_check":
                return BLACKLIST_CHECK;
            case "sensitive_check":
                return SENSITIVE_CHECK;
            case "coordination_check":
                return COORDINATION_CHECK;
            case "electronic_check":
                return ELECTRONIC_CHECK;
            case "error_code_no_check":
                return ERROR_CODE_NO_CHECK;
            case "invoice_status_check":
                return INVOICE_STATUS_CHECK;
            case "is_replace_check":
                return IS_REPLACE_CHECK;
            case "legal_person_check":
                return LEGAL_PERSON_CHECK;
            case "person_check":
                return PERSON_CHECK;
            case "repeat_check":
                return REPEAT_CHECK;
            case "sales_list_check":
                return SALES_LIST_CHECK;
            case "consecutive_check":
                return CONSECUTIVE_CHECK;
            case "sheet_check":
                return SHEET_CHECK;
            case "stamper_check":
                return STAMPER_CHECK;
            case "user_auth_check":
                return USER_AUTH_CHECK;
            case "verify_result_check":
                return VERIFY_RESULT_CHECK;
            case "sign_result_check":
                return SIGN_RESULT_CHECK;
            case "purchase_repeat_check":
                return PURCHASE_REPEAT_CHECK;
            case "sheet_deduct_check":
                return SHEET_DEDUCT_CHECK;
            case "ticket_remark_check":
                return TICKET_REMARK_CHECK;
            case "rec_failed_check":
                return REC_FAILED_CHECK;
            case "used_amount_check":
                return USED_AMOUNT_CHECK;
            case "customs_payment_check":
                return CUSTOMS_PAYMENT_CHECK;
            case "invoice_purchaser_tax_no_check":
                return INVOICE_PURCHASER_TAX_NO_CHECK;
            case "all_electric_auth_check":
                return ALL_ELECTRIC_AUTH_CHECK;
            case "is_cover_ticket_check":
                return IS_COVER_TICKET_CHECK;
            case "balance_amount_check":
                return BALANCE_AMOUNT_CHECK;
            case "purchase_cooperate_check":
                return PURCHASE_COOPERATE_CHECK;
            case "special_invoice_check":
                return SPECIAL_INVOICE_CHECK;
            case "ticket_bank_check":
                return TICKET_BANK_CHECK;
            default:
                return null;
        }
    }
}
