package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 机动车发票联次
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum VehicleSheet {

    _1("1", "发票联"),
    _2("2", "抵扣联"),
    _3("3", "报税联"),
    _4("4", "注册登记联"),
    _5("5", "记账联"),
    _6("6", "存根联");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VehicleSheet(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VehicleSheet fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
