package com.xforceplus.ultraman.app.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.imagesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketCustomsDeclaration extends Ticket {


  /**
   * 预录入编号
   */
  private String prerecordNumber;

  /**
   * 海关编号
   */
  private String recordNumber;

  /**
   * 境内( 收货人|发货人)
   */
  private String consignor;

  /**
   * 出境关别
   */
  private String exportPort;

  /**
   * 出口日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exportDate;

  /**
   * 申报日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime declaringDate;

  /**
   * 备案号
   */
  private String registrationNumber;

  /**
   * 境外收货人|发货人
   */
  private String consignee;

  /**
   * 运输方式
   */
  private String transportMode;

  /**
   * 提运单号
   */
  private String transportBillNumber;

  /**
   * 货物存放地点
   */
  private String storageLocation;

  /**
   * 消费使用单位
   */
  private String produceConsume;

  /**
   * 监管方式
   */
  private String supervisionMode;

  /**
   * 征免性质
   */
  private String levyOrExemption;

  /**
   * 许可证号
   */
  private String licenseNo;

  /**
   * 启运港
   */
  private String departurePort;

  /**
   * 合同协议号
   */
  private String approvalNumber;

  /**
   * 贸易国
   */
  private String dispatchCountry;

  /**
   * 启运国
   */
  private String startArrivalCountry;

  /**
   * 经停港
   */
  private String stopoverDestinationPort;

  /**
   * 包装种类
   */
  private String packageType;

  /**
   * 件数
   */
  private String quantity;

  /**
   * 毛重
   */
  private String grossWeight;

  /**
   * 净重
   */
  private String netWeight;

  /**
   * 成交方式
   */
  private String dealMode;

  /**
   * 运费
   */
  private String freight;

  /**
   * 保费
   */
  private String premiums;

  /**
   * 杂费
   */
  private String sundryCharges;

  /**
   * 随附单证及编号
   */
  private String attachment;

  /**
   * 标记唛码及备注
   */
  private String markAndRemark;

  /**
   * 特殊关系确认
   */
  private Boolean specialRelationShipFlag;

  /**
   * 价格影响确认
   */
  @TableField("priceImpact_flag")
  private Boolean priceimpactFlag;

  /**
   * 支付特许权使用费
   */
  private String payRoyaltiesFlag;

  /**
   * 公式定价确认
   */
  private Boolean formulaPricingFlag;

  /**
   * 暂定价格确认
   */
  private Boolean provisionalPriceFlag;

  /**
   * 自报自缴
   */
  private Boolean selfReportPayFlag;

  /**
   * 报关人员
   */
  private String customsBroker;

  /**
   * 报关人员证号
   */
  private String customsBrokerId;

  /**
   * 电话
   */
  private String customsBrokerTel;

  /**
   * 申报单位
   */
  private String applicantCompany;

  /**
   * 票据类型
   */
  private String customsFormType;

  /**
   * 境内发货人ID
   */
  private String consignorId;

  /**
   * 出境关别ID
   */
  private String exportPortId;

  /**
   * 运输方式ID
   */
  private String transportModeId;

  /**
   * 运输工具ID
   */
  private String transportToolId;

  /**
   * 监管方式ID
   */
  private String supervisionModeId;

  /**
   * 征免性质ID
   */
  private String levyOrExemptionId;

  /**
   * 贸易国ID
   */
  private String dispatchCountryId;

  /**
   * 包装种类ID
   */
  private String packageTypeId;

  /**
   * 成交方式ID
   */
  private String dealModeId;

  /**
   * 进境关别
   */
  private String importPort;

  /**
   * 进口日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime importDate;

  /**
   * 消费使用单位ID
   */
  private String produceConsumeId;

  /**
   * 消费使用单位ID
   */
  private String sellerId;

  /**
   * 消费使用单位
   */
  private String seller;

  /**
   * 启运港ID
   */
  private String departurePortId;

  /**
   * 启运国
   */
  private String startArrivalCountryId;

  /**
   * 运抵国
   */
  private String arrivalCountry;

  /**
   * 运抵国ID
   */
  private String arrivalCountryId;

  /**
   * 指运港
   */
  private String destinationPort;

  /**
   * 指运港ID
   */
  private String destinationPortId;

  /**
   * 入境口岸
   */
  private String domesticPortImport;

  /**
   * 离境口岸
   */
  private String domesticPortExport;

  /**
   * 入境口岸ID
   */
  private String domesticPortImportId;

  /**
   * 离境口岸ID
   */
  private String domesticPortExportId;

  /**
   * 进境关别ID
   */
  private String importPortId;

  /**
   * 经停港
   */
  private String stopoverDestinationPortId;

  /**
   * 出入境口岸
   */
  private String domesticPort;

  /**
   * 出入境口岸ID
   */
  private String domesticPortId;

  /**
   * 运输工具
   */
  private String transportTool;

  /**
   * 境内发货人
   */
  private String consignorImport;

  /**
   * 境外发货人
   */
  private String consignorExport;

  /**
   * 境内发货人ID
   */
  private String consignorImportId;

  /**
   * 境外发货人ID
   */
  private String consignorExportId;

  /**
   * 境内收货人
   */
  private String consigneeImport;

  /**
   * 境内收货人ID
   */
  private String consigneeImportId;

  /**
   * 境外收货人
   */
  private String consigneeExport;

  /**
   * 境外收货人ID
   */
  private String consigneeExportId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("prerecord_number", prerecordNumber);
      map.put("record_number", recordNumber);
      map.put("consignor", consignor);
      map.put("export_port", exportPort);
      map.put("export_date", BocpGenUtils.toTimestamp(exportDate));
      map.put("declaring_date", BocpGenUtils.toTimestamp(declaringDate));
      map.put("registration_number", registrationNumber);
      map.put("consignee", consignee);
      map.put("transport_mode", transportMode);
      map.put("transport_bill_number", transportBillNumber);
      map.put("storage_location", storageLocation);
      map.put("produce_consume", produceConsume);
      map.put("supervision_mode", supervisionMode);
      map.put("levy_or_exemption", levyOrExemption);
      map.put("license_no", licenseNo);
      map.put("departure_port", departurePort);
      map.put("approval_number", approvalNumber);
      map.put("dispatch_country", dispatchCountry);
      map.put("start_arrival_country", startArrivalCountry);
      map.put("stopover_destination_port", stopoverDestinationPort);
      map.put("package_type", packageType);
      map.put("quantity", quantity);
      map.put("gross_weight", grossWeight);
      map.put("net_weight", netWeight);
      map.put("deal_mode", dealMode);
      map.put("freight", freight);
      map.put("premiums", premiums);
      map.put("sundry_charges", sundryCharges);
      map.put("attachment", attachment);
      map.put("mark_and_remark", markAndRemark);
      map.put("special_relation_ship_flag", specialRelationShipFlag);
      map.put("priceImpact_flag", priceimpactFlag);
      map.put("pay_royalties_flag", payRoyaltiesFlag);
      map.put("formula_pricing_flag", formulaPricingFlag);
      map.put("provisional_price_flag", provisionalPriceFlag);
      map.put("self_report_pay_flag", selfReportPayFlag);
      map.put("customs_broker", customsBroker);
      map.put("customs_broker_id", customsBrokerId);
      map.put("customs_broker_tel", customsBrokerTel);
      map.put("applicant_company", applicantCompany);
      map.put("customs_form_type", customsFormType);
      map.put("consignor_id", consignorId);
      map.put("export_port_id", exportPortId);
      map.put("transport_mode_id", transportModeId);
      map.put("transport_tool_id", transportToolId);
      map.put("supervision_mode_id", supervisionModeId);
      map.put("levy_or_exemption_id", levyOrExemptionId);
      map.put("dispatch_country_id", dispatchCountryId);
      map.put("package_type_id", packageTypeId);
      map.put("deal_mode_id", dealModeId);
      map.put("import_port", importPort);
      map.put("import_date", BocpGenUtils.toTimestamp(importDate));
      map.put("produce_consume_id", produceConsumeId);
      map.put("seller_id", sellerId);
      map.put("seller", seller);
      map.put("departure_port_id", departurePortId);
      map.put("start_arrival_country_id", startArrivalCountryId);
      map.put("arrival_country", arrivalCountry);
      map.put("arrival_country_id", arrivalCountryId);
      map.put("destination_port", destinationPort);
      map.put("destination_port_id", destinationPortId);
      map.put("domestic_port_import", domesticPortImport);
      map.put("domestic_port_export", domesticPortExport);
      map.put("domestic_port_import_id", domesticPortImportId);
      map.put("domestic_port_export_id", domesticPortExportId);
      map.put("import_port_id", importPortId);
      map.put("stopover_destination_port_id", stopoverDestinationPortId);
      map.put("domestic_port", domesticPort);
      map.put("domestic_port_id", domesticPortId);
      map.put("transport_tool", transportTool);
      map.put("consignor_import", consignorImport);
      map.put("consignor_export", consignorExport);
      map.put("consignor_import_id", consignorImportId);
      map.put("consignor_export_id", consignorExportId);
      map.put("consignee_import", consigneeImport);
      map.put("consignee_import_id", consigneeImportId);
      map.put("consignee_export", consigneeExport);
      map.put("consignee_export_id", consigneeExportId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketCustomsDeclaration fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketCustomsDeclaration entity = new TicketCustomsDeclaration();
    entity.setParentByOQSMap(map);
    if(map.containsKey("prerecord_number")) {
      Object obj = map.get("prerecord_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrerecordNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("record_number")) {
      Object obj = map.get("record_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecordNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor")) {
      Object obj = map.get("consignor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("export_port")) {
      Object obj = map.get("export_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExportPort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("export_date")) {
      Object obj = map.get("export_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExportDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExportDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExportDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExportDate(null);
      }
    }
    if(map.containsKey("declaring_date")) {
      Object obj = map.get("declaring_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeclaringDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeclaringDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeclaringDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeclaringDate(null);
      }
    }
    if(map.containsKey("registration_number")) {
      Object obj = map.get("registration_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegistrationNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee")) {
      Object obj = map.get("consignee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_mode")) {
      Object obj = map.get("transport_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_bill_number")) {
      Object obj = map.get("transport_bill_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportBillNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storage_location")) {
      Object obj = map.get("storage_location");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStorageLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produce_consume")) {
      Object obj = map.get("produce_consume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduceConsume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supervision_mode")) {
      Object obj = map.get("supervision_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupervisionMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levy_or_exemption")) {
      Object obj = map.get("levy_or_exemption");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevyOrExemption((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("license_no")) {
      Object obj = map.get("license_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLicenseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departure_port")) {
      Object obj = map.get("departure_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeparturePort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_number")) {
      Object obj = map.get("approval_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovalNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dispatch_country")) {
      Object obj = map.get("dispatch_country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDispatchCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_arrival_country")) {
      Object obj = map.get("start_arrival_country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartArrivalCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stopover_destination_port")) {
      Object obj = map.get("stopover_destination_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStopoverDestinationPort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_type")) {
      Object obj = map.get("package_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gross_weight")) {
      Object obj = map.get("gross_weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrossWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("net_weight")) {
      Object obj = map.get("net_weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_mode")) {
      Object obj = map.get("deal_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("premiums")) {
      Object obj = map.get("premiums");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPremiums((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sundry_charges")) {
      Object obj = map.get("sundry_charges");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSundryCharges((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment")) {
      Object obj = map.get("attachment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttachment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mark_and_remark")) {
      Object obj = map.get("mark_and_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarkAndRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_relation_ship_flag")) {
      Object obj = map.get("special_relation_ship_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSpecialRelationShipFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecialRelationShipFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("priceImpact_flag")) {
      Object obj = map.get("priceImpact_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPriceimpactFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceimpactFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pay_royalties_flag")) {
      Object obj = map.get("pay_royalties_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayRoyaltiesFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("formula_pricing_flag")) {
      Object obj = map.get("formula_pricing_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFormulaPricingFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFormulaPricingFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("provisional_price_flag")) {
      Object obj = map.get("provisional_price_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setProvisionalPriceFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProvisionalPriceFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("self_report_pay_flag")) {
      Object obj = map.get("self_report_pay_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSelfReportPayFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSelfReportPayFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("customs_broker")) {
      Object obj = map.get("customs_broker");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomsBroker((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customs_broker_id")) {
      Object obj = map.get("customs_broker_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomsBrokerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customs_broker_tel")) {
      Object obj = map.get("customs_broker_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomsBrokerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicant_company")) {
      Object obj = map.get("applicant_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicantCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customs_form_type")) {
      Object obj = map.get("customs_form_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomsFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor_id")) {
      Object obj = map.get("consignor_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignorId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("export_port_id")) {
      Object obj = map.get("export_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExportPortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_mode_id")) {
      Object obj = map.get("transport_mode_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportModeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_tool_id")) {
      Object obj = map.get("transport_tool_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportToolId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supervision_mode_id")) {
      Object obj = map.get("supervision_mode_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupervisionModeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levy_or_exemption_id")) {
      Object obj = map.get("levy_or_exemption_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevyOrExemptionId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dispatch_country_id")) {
      Object obj = map.get("dispatch_country_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDispatchCountryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_type_id")) {
      Object obj = map.get("package_type_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageTypeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_mode_id")) {
      Object obj = map.get("deal_mode_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealModeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_port")) {
      Object obj = map.get("import_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportPort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_date")) {
      Object obj = map.get("import_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImportDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setImportDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setImportDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setImportDate(null);
      }
    }
    if(map.containsKey("produce_consume_id")) {
      Object obj = map.get("produce_consume_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduceConsumeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departure_port_id")) {
      Object obj = map.get("departure_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeparturePortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_arrival_country_id")) {
      Object obj = map.get("start_arrival_country_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartArrivalCountryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrival_country")) {
      Object obj = map.get("arrival_country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArrivalCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arrival_country_id")) {
      Object obj = map.get("arrival_country_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArrivalCountryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destination_port")) {
      Object obj = map.get("destination_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDestinationPort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destination_port_id")) {
      Object obj = map.get("destination_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDestinationPortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port_import")) {
      Object obj = map.get("domestic_port_import");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPortImport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port_export")) {
      Object obj = map.get("domestic_port_export");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPortExport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port_import_id")) {
      Object obj = map.get("domestic_port_import_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPortImportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port_export_id")) {
      Object obj = map.get("domestic_port_export_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPortExportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_port_id")) {
      Object obj = map.get("import_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportPortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stopover_destination_port_id")) {
      Object obj = map.get("stopover_destination_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStopoverDestinationPortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port")) {
      Object obj = map.get("domestic_port");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPort((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domestic_port_id")) {
      Object obj = map.get("domestic_port_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomesticPortId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_tool")) {
      Object obj = map.get("transport_tool");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportTool((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor_import")) {
      Object obj = map.get("consignor_import");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignorImport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor_export")) {
      Object obj = map.get("consignor_export");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignorExport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor_import_id")) {
      Object obj = map.get("consignor_import_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignorImportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignor_export_id")) {
      Object obj = map.get("consignor_export_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsignorExportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee_import")) {
      Object obj = map.get("consignee_import");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsigneeImport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee_import_id")) {
      Object obj = map.get("consignee_import_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsigneeImportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee_export")) {
      Object obj = map.get("consignee_export");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsigneeExport((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignee_export_id")) {
      Object obj = map.get("consignee_export_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsigneeExportId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("prerecord_number")) {
      Object obj = map.get("prerecord_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrerecordNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("record_number")) {
      Object obj = map.get("record_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecordNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor")) {
      Object obj = map.get("consignor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("export_port")) {
      Object obj = map.get("export_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExportPort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("export_date")) {
      Object obj = map.get("export_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExportDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExportDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExportDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExportDate(null);
      }
    }
    if(map.containsKey("declaring_date")) {
      Object obj = map.get("declaring_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeclaringDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeclaringDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeclaringDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeclaringDate(null);
      }
    }
    if(map.containsKey("registration_number")) {
      Object obj = map.get("registration_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegistrationNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignee")) {
      Object obj = map.get("consignee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_mode")) {
      Object obj = map.get("transport_mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_bill_number")) {
      Object obj = map.get("transport_bill_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportBillNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storage_location")) {
      Object obj = map.get("storage_location");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStorageLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("produce_consume")) {
      Object obj = map.get("produce_consume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduceConsume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supervision_mode")) {
      Object obj = map.get("supervision_mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupervisionMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levy_or_exemption")) {
      Object obj = map.get("levy_or_exemption");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevyOrExemption((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("license_no")) {
      Object obj = map.get("license_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLicenseNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departure_port")) {
      Object obj = map.get("departure_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeparturePort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approval_number")) {
      Object obj = map.get("approval_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApprovalNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dispatch_country")) {
      Object obj = map.get("dispatch_country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDispatchCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_arrival_country")) {
      Object obj = map.get("start_arrival_country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartArrivalCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stopover_destination_port")) {
      Object obj = map.get("stopover_destination_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStopoverDestinationPort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("package_type")) {
      Object obj = map.get("package_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gross_weight")) {
      Object obj = map.get("gross_weight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGrossWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("net_weight")) {
      Object obj = map.get("net_weight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_mode")) {
      Object obj = map.get("deal_mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freight")) {
      Object obj = map.get("freight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("premiums")) {
      Object obj = map.get("premiums");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPremiums((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sundry_charges")) {
      Object obj = map.get("sundry_charges");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSundryCharges((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachment")) {
      Object obj = map.get("attachment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttachment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mark_and_remark")) {
      Object obj = map.get("mark_and_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarkAndRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("special_relation_ship_flag")) {
      Object obj = map.get("special_relation_ship_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSpecialRelationShipFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpecialRelationShipFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("priceImpact_flag")) {
      Object obj = map.get("priceImpact_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPriceimpactFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceimpactFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pay_royalties_flag")) {
      Object obj = map.get("pay_royalties_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayRoyaltiesFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("formula_pricing_flag")) {
      Object obj = map.get("formula_pricing_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setFormulaPricingFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFormulaPricingFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("provisional_price_flag")) {
      Object obj = map.get("provisional_price_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setProvisionalPriceFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProvisionalPriceFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("self_report_pay_flag")) {
      Object obj = map.get("self_report_pay_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSelfReportPayFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSelfReportPayFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("customs_broker")) {
      Object obj = map.get("customs_broker");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomsBroker((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customs_broker_id")) {
      Object obj = map.get("customs_broker_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomsBrokerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customs_broker_tel")) {
      Object obj = map.get("customs_broker_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomsBrokerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicant_company")) {
      Object obj = map.get("applicant_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicantCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customs_form_type")) {
      Object obj = map.get("customs_form_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomsFormType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor_id")) {
      Object obj = map.get("consignor_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignorId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("export_port_id")) {
      Object obj = map.get("export_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExportPortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_mode_id")) {
      Object obj = map.get("transport_mode_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportModeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_tool_id")) {
      Object obj = map.get("transport_tool_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportToolId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supervision_mode_id")) {
      Object obj = map.get("supervision_mode_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupervisionModeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levy_or_exemption_id")) {
      Object obj = map.get("levy_or_exemption_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevyOrExemptionId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dispatch_country_id")) {
      Object obj = map.get("dispatch_country_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDispatchCountryId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("package_type_id")) {
      Object obj = map.get("package_type_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageTypeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_mode_id")) {
      Object obj = map.get("deal_mode_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealModeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_port")) {
      Object obj = map.get("import_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportPort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_date")) {
      Object obj = map.get("import_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setImportDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setImportDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setImportDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setImportDate(null);
      }
    }
    if(map.containsKey("produce_consume_id")) {
      Object obj = map.get("produce_consume_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduceConsumeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeller((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departure_port_id")) {
      Object obj = map.get("departure_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeparturePortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_arrival_country_id")) {
      Object obj = map.get("start_arrival_country_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartArrivalCountryId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("arrival_country")) {
      Object obj = map.get("arrival_country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArrivalCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("arrival_country_id")) {
      Object obj = map.get("arrival_country_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArrivalCountryId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("destination_port")) {
      Object obj = map.get("destination_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDestinationPort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("destination_port_id")) {
      Object obj = map.get("destination_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDestinationPortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port_import")) {
      Object obj = map.get("domestic_port_import");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPortImport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port_export")) {
      Object obj = map.get("domestic_port_export");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPortExport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port_import_id")) {
      Object obj = map.get("domestic_port_import_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPortImportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port_export_id")) {
      Object obj = map.get("domestic_port_export_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPortExportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_port_id")) {
      Object obj = map.get("import_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportPortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stopover_destination_port_id")) {
      Object obj = map.get("stopover_destination_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStopoverDestinationPortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port")) {
      Object obj = map.get("domestic_port");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPort((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domestic_port_id")) {
      Object obj = map.get("domestic_port_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomesticPortId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_tool")) {
      Object obj = map.get("transport_tool");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportTool((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor_import")) {
      Object obj = map.get("consignor_import");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignorImport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor_export")) {
      Object obj = map.get("consignor_export");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignorExport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor_import_id")) {
      Object obj = map.get("consignor_import_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignorImportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignor_export_id")) {
      Object obj = map.get("consignor_export_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsignorExportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignee_import")) {
      Object obj = map.get("consignee_import");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsigneeImport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignee_import_id")) {
      Object obj = map.get("consignee_import_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsigneeImportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignee_export")) {
      Object obj = map.get("consignee_export");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsigneeExport((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consignee_export_id")) {
      Object obj = map.get("consignee_export_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsigneeExportId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
