package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * deploy_mode
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum DeployMode {

    SAAS("SAAS", "SAAS云服务"),
    LOCAL("LOCAL", "属地服务");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DeployMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeployMode fromCode(String code){
        switch(code) {
            case "SAAS":
                return SAAS;
            case "LOCAL":
                return LOCAL;
            default:
                return null;
        }
    }
}
