package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * page_code
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum PageCode {

    SCAN("scan", "影像采集"),
    ADVANCE_PAYMENT("advancePayment", "预付款"),
    PERSON_TICKET("personTicket", "个人单证池"),
    SCAN_DETAIL("scanDetail", "影像详情");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PageCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PageCode fromCode(String code){
        switch(code) {
            case "scan":
                return SCAN;
            case "advancePayment":
                return ADVANCE_PAYMENT;
            case "personTicket":
                return PERSON_TICKET;
            case "scanDetail":
                return SCAN_DETAIL;
            default:
                return null;
        }
    }
}
