package com.xforceplus.ultraman.app.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.imagesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketUsedCar extends Ticket {


  /**
   * 注册号
   */
  private String registrationNo;

  /**
   * 拍卖者名称
   */
  private String auctioneersName;

  /**
   * 拍卖者地址
   */
  private String auctioneersAddress;

  /**
   * 拍卖者税号
   */
  private String auctioneersTaxNo;

  /**
   * 拍卖者银行信息
   */
  private String auctioneersBankInfo;

  /**
   * 拍卖者电话
   */
  private String auctioneersTel;

  /**
   * 二手车市场名称
   */
  private String usedCarMarketName;

  /**
   * 二手车市场地址
   */
  private String usedCarMarketAddress;

  /**
   * 二手车市场税号
   */
  private String usedCarMarketTaxNo;

  /**
   * 二手车市场银行信息
   */
  private String usedCarMarketBankInfo;

  /**
   * 二手车市场电话
   */
  private String usedCarMarketTel;

  /**
   * 车牌号
   */
  private String carNumber;

  /**
   * 地区名称
   */
  private String dpName;

  /**
   * 转入地车辆车管所名称
   */
  private String vehiclePlaceName;

  /**
   * 拍卖者开户行
   */
  private String auctioneersBank;

  /**
   * 二手车市场开户行
   */
  private String usedCarMarketBank;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("registration_no", registrationNo);
      map.put("auctioneers_name", auctioneersName);
      map.put("auctioneers_address", auctioneersAddress);
      map.put("auctioneers_tax_no", auctioneersTaxNo);
      map.put("auctioneers_bank_info", auctioneersBankInfo);
      map.put("auctioneers_tel", auctioneersTel);
      map.put("used_car_market_name", usedCarMarketName);
      map.put("used_car_market_address", usedCarMarketAddress);
      map.put("used_car_market_tax_no", usedCarMarketTaxNo);
      map.put("used_car_market_bank_info", usedCarMarketBankInfo);
      map.put("used_car_market_tel", usedCarMarketTel);
      map.put("car_number", carNumber);
      map.put("dp_name", dpName);
      map.put("vehicle_place_name", vehiclePlaceName);
      map.put("auctioneers_bank", auctioneersBank);
      map.put("used_car_market_bank", usedCarMarketBank);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketUsedCar fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketUsedCar entity = new TicketUsedCar();
    entity.setParentByOQSMap(map);
    if(map.containsKey("registration_no")) {
      Object obj = map.get("registration_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegistrationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_name")) {
      Object obj = map.get("auctioneers_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_address")) {
      Object obj = map.get("auctioneers_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_tax_no")) {
      Object obj = map.get("auctioneers_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_bank_info")) {
      Object obj = map.get("auctioneers_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_tel")) {
      Object obj = map.get("auctioneers_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_name")) {
      Object obj = map.get("used_car_market_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_address")) {
      Object obj = map.get("used_car_market_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_tax_no")) {
      Object obj = map.get("used_car_market_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_bank_info")) {
      Object obj = map.get("used_car_market_bank_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_tel")) {
      Object obj = map.get("used_car_market_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("car_number")) {
      Object obj = map.get("car_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dp_name")) {
      Object obj = map.get("dp_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDpName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_place_name")) {
      Object obj = map.get("vehicle_place_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehiclePlaceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auctioneers_bank")) {
      Object obj = map.get("auctioneers_bank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuctioneersBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("used_car_market_bank")) {
      Object obj = map.get("used_car_market_bank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUsedCarMarketBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("registration_no")) {
      Object obj = map.get("registration_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegistrationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_name")) {
      Object obj = map.get("auctioneers_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_address")) {
      Object obj = map.get("auctioneers_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_tax_no")) {
      Object obj = map.get("auctioneers_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_bank_info")) {
      Object obj = map.get("auctioneers_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_tel")) {
      Object obj = map.get("auctioneers_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_name")) {
      Object obj = map.get("used_car_market_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_address")) {
      Object obj = map.get("used_car_market_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_tax_no")) {
      Object obj = map.get("used_car_market_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_bank_info")) {
      Object obj = map.get("used_car_market_bank_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_tel")) {
      Object obj = map.get("used_car_market_tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("car_number")) {
      Object obj = map.get("car_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dp_name")) {
      Object obj = map.get("dp_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDpName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_place_name")) {
      Object obj = map.get("vehicle_place_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehiclePlaceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auctioneers_bank")) {
      Object obj = map.get("auctioneers_bank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuctioneersBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("used_car_market_bank")) {
      Object obj = map.get("used_car_market_bank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUsedCarMarketBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
